<?php

namespace Import\ApiBundle\Entity;

use Doctrine\ORM\Mapping as ORM;
use JMS\Serializer\Annotation\ExclusionPolicy;
use JMS\Serializer\Annotation\Expose;
use JMS\Serializer\Annotation\Groups as AnnotationGroups;

/**
 * PaymentAvg
 *
 * @ORM\Table(name="payment_avg")
 * @ORM\Entity(repositoryClass="Import\ApiBundle\Repository\PaymentAvgRepository")
 *
 * @ExclusionPolicy("all")
 */
class PaymentAvg
{
    /**
     * @var integer
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @var integer
     *
     * @ORM\Column(name="year", type="integer")
     *
     * @Expose
     * @AnnotationGroups({"indicatorsDetails"})
     */
    private $year;

    /**
     * @var integer
     *
     * @ORM\Column(name="month", type="integer")
     *
     * @Expose
     * @AnnotationGroups({"indicatorsDetails"})
     */
    private $month;

    /**
     * @var float
     *
     * @ORM\Column(name="value", type="float")
     *
     * @Expose
     * @AnnotationGroups({"indicatorsDetails"})
     */
    private $value;

    /**
     * @var string $description
     *
     * @ORM\Column(name="description", type="string", length=255)
     *
     * @Expose
     * @AnnotationGroups({"indicatorsDetails"})
     */
    private $description;

    /**
     * Get id
     *
     * @return integer 
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set year
     *
     * @param integer $year
     * @return PaymentAvg
     */
    public function setYear($year)
    {
        $this->year = $year;
    
        return $this;
    }

    /**
     * Get year
     *
     * @return integer 
     */
    public function getYear()
    {
        return $this->year;
    }

    /**
     * Set month
     *
     * @param integer $month
     * @return PaymentAvg
     */
    public function setMonth($month)
    {
        $this->month = $month;
    
        return $this;
    }

    /**
     * Get month
     *
     * @return integer 
     */
    public function getMonth()
    {
        return $this->month;
    }

    /**
     * Set value
     *
     * @param float $value
     * @return PaymentAvg
     */
    public function setValue($value)
    {
        $this->value = $value;
    
        return $this;
    }

    /**
     * Get value
     *
     * @return float 
     */
    public function getValue()
    {
        return $this->value;
    }

    /**
     * Set description
     *
     * @param string $description
     * @return PaymentAvg
     */
    public function setDescription($description)
    {
        $this->description = $description;
    
        return $this;
    }

    /**
     * Get description
     *
     * @return string 
     */
    public function getDescription()
    {
        return $this->description;
    }
}